function [xlscaled, ylscaled, ylmtr] = welllogscaler( logshp, xscaleshp, yscaleshp )
% [xlscaled, ylscaled, ylmtr] = welllogscaler( logshp, xscaleshp, yscaleshp )
% Scales well logs

% Scale in x direction first (most important as logs are very long an
% portrait.

% xsx = [xscaleshp.X];
% ysx = [xscaleshp.Y];

% xssnippedx = nansnip( xsx );
% yssnippedx = nansnip( ysx );

% [m, minidx] = min( xscaleshp.data( :, strmatch('scale', xscaleshp.vnames) ) );
% [m, maxidx] = max( xscaleshp.data( :, strmatch('scale', xscaleshp.vnames) ) );
% 



[m, minidx] = min( [xscaleshp.scale]);
[m, maxidx] = max( [xscaleshp.scale]);

clear m;

xsx1 = xscaleshp( minidx).X;
ysx1 = xscaleshp( minidx).Y;

xsx2 = xscaleshp( maxidx).X;
ysx2 = xscaleshp( maxidx).Y;

scale1 = xscaleshp( minidx ).scale;
scale2 = xscaleshp( maxidx ).scale;


xl = [logshp.X];
yl = [logshp.Y];


xls1 = interp1( ysx1, xsx1, yl );
xls2 = interp1( ysx2, xsx2, yl );

xlscaled = scale1 + ( (xl - xls1) ./ (xls2 - xls1) ) .* (scale2 - scale1) ;


% Scale in y direction

% xsy = yscaleshp.X;
% ysy = yscaleshp.Y;

% xssnippedy = nansnip( xsy );
% yssnippedy = nansnip( ysy );

for idx = 1: length( yscaleshp ),
    yav(idx) = mean( [yscaleshp(idx).Y] );
end

yscales = [yscaleshp.scale];

Py = polyfit( yav, yscales, 1 );

ylscaled = polyval( Py, yl );

ylmtr = ylscaled .* 0.304799997988;
